<?php
  // This test simulates real-life situation:
  //   {{TOC}} ... {{If format=html; Include footer.html}}
  // Include's priority is higher than TOC's; normally both Include & TOC are static but since Include
  // depends on dynamic If action it becomes dynamic; so does TOC. WHen rendering, Include must be
  // called before TOC so that headings from the included document are included in common TOC.

class Utfplog_Root extends UWikiBaseAction {
  public $parameterOrder = array('param1', 'param2');

  function Execute($format, $params) { $GLOBALS['tfpParams'][] = $params; }
}


    $src = '{{tfpLog byOrder1, byOrder2, flag}}';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');

  global $tfpParams;

    $tfpParams = array();
      $doc->Parse();
    TestThat( count($tfpParams) === 1 );
    TestThat( $tfpParams[0]['param1'] === 'byOrder1' and $tfpParams[0]['param2'] === 'byOrder2' );
    TestThat( $tfpParams[0]['flag'] === true );

    // testing optional colon after formatter name.
    $src = '{{tfpLog : some spaces = to be trimmed}}';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');

    $tfpParams = array();
      $doc->Parse();
    TestThat( count($tfpParams) === 1 );
    TestThat( $tfpParams[0][': some spaces'] === 'to be trimmed' );

    $src = '{{tfpLog: byOrder1, byName=value, flag}}';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');

    $tfpParams = array();
      $doc->Parse();
    TestThat( count($tfpParams) === 1 );
    TestThat( $tfpParams[0]['param1'] === 'byOrder1' and $tfpParams[0]['byName'] === 'value' );
    TestThat( $tfpParams[0]['flag'] === true );

    $src = '{{tfpLog :byOrder1; tfpLog: byName="va; ""lue", "fl"""", ag"}}';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');

    $tfpParams = array();
      $doc->Parse();
    TestThat( count($tfpParams) === 2 );
    TestThat( $tfpParams[0]['param1'] === ':byOrder1' );
    TestThat( $tfpParams[1]['byName'] === 'va; "lue' and $tfpParams[1]['fl"", ag'] === true );

    $src = '{{tfpLog """name"""="""value""", name2=""value?"", "v""""al ""u"" e"}}';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');

    $tfpParams = array();
      $doc->Parse();
    TestThat( count($tfpParams) === 1 );
    // name2's value is empty because there's even number of "s: "" (which closes arg's
    // value off), then value"" which is lost. It must be: """value""" (leading and trailing
    // " start and end the argument and double "s are quoted apostrophes).
    TestThat( $tfpParams[0]['"name"'] === '"value"' and $tfpParams[0]['name2'] === ''
              and $tfpParams[0]['v""al "u" e'] === true );

    $src = '{{tfpLog pa ram}}';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');

    $tfpParams = array();
      $doc->Parse();
    TestThat( count($tfpParams) === 1 );
    TestThat( $tfpParams[0]['param1'] === 'pa ram' );

    $src = '{{tfpLog, tfpLog, tfpLog}}';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');

    $tfpParams = array();
      $doc->Parse();
    TestThat( count($tfpParams) === 3 );
    TestThat( empty( $tfpParams[0] ) and empty( $tfpParams[1] ) and empty( $tfpParams[2] ) );
